<?php
/* Installazione modulo Settings → WPPConnect */

ini_set('display_errors', 1);
error_reporting(E_ALL);

global $adb;

echo "<pre>";
echo "=== Installazione WPPConnect ===\n";

// 1. Creazione tabella
try {
    $adb->pquery("
    CREATE TABLE IF NOT EXISTS vte_wppconnect_config (
      id INT AUTO_INCREMENT PRIMARY KEY,
      base_url VARCHAR(255) NOT NULL,
      session_name VARCHAR(100) NOT NULL,
      secret_key VARCHAR(255) NOT NULL,
      webhook VARCHAR(500) DEFAULT NULL,
      token VARCHAR(255) DEFAULT NULL,
      is_connected TINYINT(1) NOT NULL DEFAULT 0,
      created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
      updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )", array());

    // verifica
    $check = $adb->pquery("SHOW TABLES LIKE 'vte_wppconnect_config'", array());
    if ($adb->num_rows($check) > 0) {
        echo "✓ Tabella vte_wppconnect_config creata/già presente\n";
    } else {
        echo "✗ ERRORE: tabella non trovata!\n";
    }
} catch (Exception $e) {
    echo "✗ ERRORE creazione tabella: ".$e->getMessage()."\n";
}

// 2. Registrazione voce menu
try {
    $blockRes = $adb->pquery("SELECT blockid FROM vte_settings_blocks WHERE label=?", array('LBL_OTHER_SETTINGS'));
    if ($blockRes && $adb->num_rows($blockRes) > 0) {
        $blockid = $adb->query_result($blockRes, 0, 'blockid');

        $check = $adb->pquery("SELECT 1 FROM vte_settings_field WHERE name=?", array('WPPConnect'));
        if ($adb->num_rows($check) == 0) {
            $fieldid = $adb->getUniqueID('vte_settings_field');
            $adb->pquery(
                "INSERT INTO vte_settings_field(fieldid, blockid, name, iconpath, description, linkto, sequence, active) 
                 VALUES (?,?,?,?,?,?,?,?)",
                array(
                    $fieldid,
                    $blockid,
                    'WPPConnect',
                    'modules/Settings/WPPConnect/icon.png',
                    'Configurazione connessione WhatsApp WPPConnect',
                    'index.php?module=Settings&action=WPPConnect',
                    1,
                    0
                )
            );
            echo "✓ Voce menu 'WPPConnect' registrata in Altre impostazioni\n";
        } else {
            echo "ℹ Voce menu 'WPPConnect' già presente, nessuna modifica\n";
        }
    } else {
        echo "✗ ERRORE: blocco LBL_OTHER_SETTINGS non trovato\n";
    }
} catch (Exception $e) {
    echo "✗ ERRORE registrazione voce menu: ".$e->getMessage()."\n";
}

echo "\nInstallazione completata\n";
echo "</pre>";
