(function boot(){
  if (!window.jQuery) return setTimeout(boot, 50);

  (function($){
    var qrCheckTimer = null;

    function post(subaction, data, cb){
      var jq = $.ajax({
        url: 'index.php?module=Settings&action=SettingsAjax&file=WPPConnect/WPPConnectAjax&ajax=1&subaction='+encodeURIComponent(subaction),
        type: 'POST',
        data: data || {},
        dataType: 'json'
      });
      if (typeof cb === 'function') jq.done(cb);
      return jq;
    }

    function show(r){ $('#wpp_status').text(JSON.stringify(r,null,2)); }

    // Animazioni Lottie
    var successAnim = lottie.loadAnimation({
      container: document.getElementById('wpp_success_anim'),
      renderer: 'svg',
      loop: false,
      autoplay: false,
      path: 'modules/Settings/WPPConnect/assets/success.json'
    });

    var loaderAnim = lottie.loadAnimation({
      container: document.getElementById('wpp_loader_anim'),
      renderer: 'svg',
      loop: true,
      autoplay: false,
      path: 'modules/Settings/WPPConnect/assets/loader.json'
    });

    // Aggiorna badge + blocco campi
    function updateConnUI(r){
      var d = r && r.data;
      var $badge = $('#wpp_conn_status');
      var $btn   = $('#btnToggleConn');

      var isConnected = false;
      if (d) {
        if (typeof d.status === 'boolean') {
          isConnected = d.status;
        } else if (typeof d.status === 'string') {
          isConnected = (d.status.toUpperCase() === 'CONNECTED');
        }
      }

      if (isConnected) {
        $badge.text('Connessione attiva')
              .css({'background':'#28a745','color':'#fff'});
        $btn.val('⏏️ Disconnetti')
            .removeClass('save').addClass('delete')
            .data('mode','logout');
        $('#wpp_base, #wpp_session, #wpp_secret, #wpp_hook').prop('readonly', true);
      } else {
        $badge.text('Disconnesso')
              .css({'background':'#dc3545','color':'#fff'});
        $btn.val('▶️ Connetti')
            .removeClass('delete').addClass('save')
            .data('mode','start');
        $('#wpp_base, #wpp_session, #wpp_secret, #wpp_hook').prop('readonly', false);
      }
    }

    // Check stato all'apertura
    post('status').done(function(r){
      show(r); updateConnUI(r);
    });

    // Polling connessione
    function waitForConnection(){
      if (qrCheckTimer) clearInterval(qrCheckTimer);
      qrCheckTimer = setInterval(function(){
        post('status').done(function(r){
          var d = r && r.data;
          var isConnected = (typeof d.status === 'boolean') ? d.status : (d.status && d.status.toUpperCase() === 'CONNECTED');
          if (!isConnected) return;

          clearInterval(qrCheckTimer);
          qrCheckTimer = null;

          $('#wpp_qr_img').hide();
          $('#wpp_success_anim').show();

          function onComplete(){
            $('#wpp_qr_popup').hide();
            $('#wpp_success_anim').hide();
            $('#wpp_qr_img').show().html('');
            updateConnUI(r);
            show(r);
            successAnim.removeEventListener('complete', onComplete);
            location.reload(); // 🔄 refresh pagina dopo connessione
          }
          successAnim.removeEventListener('complete', onComplete);
          successAnim.addEventListener('complete', onComplete);
          successAnim.goToAndPlay(0, true);
        });
      }, 1000);
    }

    // Bottone unico
    $('#btnToggleConn').off('click').on('click', function(){
      var mode = $(this).data('mode');
      var $btn = $(this);

      $('#wpp_loader_overlay').css('display','flex');
      loaderAnim.goToAndPlay(0,true);
      $btn.prop('disabled', true);

      if (mode === 'logout') {
        if (!confirm('Sei sicuro di voler disconnettere la sessione WhatsApp?')) {
          $('#wpp_loader_overlay').hide();
          $btn.prop('disabled', false);
          return;
        }
        post('logout').done(function(r){
          show(r); updateConnUI(r);
        }).always(function(){
          loaderAnim.stop();
          $('#wpp_loader_overlay').hide();
          $btn.prop('disabled', false);
          location.reload(); // 🔄 refresh dopo disconnessione
        });
      } else {
        post('start').done(function(r){
          show(r); updateConnUI(r);
          var d = r && r.data;
          var b64 = d && (d.qrcode || d.qrCode || d.base64 || d.image);
          if (b64) {
            if (!/^data:image\//i.test(b64)) b64 = 'data:image/png;base64,'+b64;
            $('#wpp_qr_img').html('<img src="'+b64+'" style="max-width:100%; border:1px solid #ccc; padding:8px; border-radius:8px;">');
            $('#wpp_qr_popup').css('display','flex');
            waitForConnection();
          }
        }).always(function(){
          loaderAnim.stop();
          $('#wpp_loader_overlay').hide();
          $btn.prop('disabled', false);
        });
      }
    });

    // Chiudi QR manualmente
    $('#btnCloseQr').off('click').on('click', function(){
      $('#wpp_qr_popup').hide();
      if (qrCheckTimer) { clearInterval(qrCheckTimer); qrCheckTimer = null; }
    });

  })(jQuery);
})();
