<?php
class Settings_WPPConnect_Config {

    public static function getConfig() {
        global $adb;
        $res = $adb->pquery("SELECT * FROM vte_wppconnect_config ORDER BY id DESC LIMIT 1", array());
        if ($res && $adb->num_rows($res) > 0) {
            return $adb->fetchByAssoc($res, -1, false);
        }
        return array(
            'base_url'     => '',
            'session_name' => '',
            'secret_key'   => '',
            'webhook'      => '',
            'token'        => '',
            'is_connected' => 0
        );
    }

    public static function saveConfig($data) {
        global $adb;
        $check = $adb->pquery("SELECT id FROM vte_wppconnect_config ORDER BY id DESC LIMIT 1", array());
        if ($check && $adb->num_rows($check) > 0) {
            $id = $adb->query_result($check, 0, 'id');
            $adb->pquery(
                "UPDATE vte_wppconnect_config 
                 SET base_url=?, session_name=?, secret_key=?, webhook=?, token=? 
                 WHERE id=?",
                array(
                    $data['base_url'],
                    $data['session_name'],
                    $data['secret_key'],
                    $data['webhook'],
                    $data['token'],
                    $id
                )
            );
        } else {
            $adb->pquery(
                "INSERT INTO vte_wppconnect_config (base_url, session_name, secret_key, webhook, token, is_connected) 
                 VALUES (?,?,?,?,?,0)",
                array(
                    $data['base_url'],
                    $data['session_name'],
                    $data['secret_key'],
                    $data['webhook'],
                    $data['token']
                )
            );
        }
    }

}
