<?php
require_once('Smarty_setup.php');
require_once('include/utils/VTEProperties.php');

require_once('include/utils/utils.php');   // i tuoi include esistenti
require_once('include/utils/VtlibUtils.php'); // se già presente

require_once('modules/Settings/WPPConnect/Config.php');

global $app_strings, $mod_strings, $theme, $currentModule;
$currentModule = 'Settings';

function vte_base_url(){
  $https = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off');
  $proto = $https ? 'https://' : 'http://';
  $host  = $_SERVER['HTTP_HOST'] ?? 'localhost';
  $base  = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');
  return $proto.$host.$base.'/';
}

$VP = VTEProperties::getInstance();

$smarty = new vtigerCRM_Smarty();

$config = Settings_WPPConnect_Config::getConfig();

$smarty->assign("WPP_BASE",   $config['base_url']);
$smarty->assign("WPP_SESSION",$config['session_name']);
$smarty->assign("WPP_SECRET", $config['secret_key']);
$smarty->assign("WPP_HOOK",   $config['webhook']);
$smarty->assign("WPP_TOKEN",  $config['token']);

$smarty->display("Settings/WPPConnect/Admin.tpl");


