<?php
/* AJAX per Settings → WPPConnect */

ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once('modules/Settings/WPPConnect/Config.php');
require_once('modules/Settings/WPPConnect/Api.php');

$subaction = isset($_REQUEST['subaction']) ? $_REQUEST['subaction'] : '';

header('Content-Type: application/json; charset=UTF-8');

switch ($subaction) {

case 'save':
    $data = [
        'base_url'     => $_REQUEST['base_url'] ?? '',
        'session_name' => $_REQUEST['session'] ?? '',
        'secret_key'   => $_REQUEST['secretkey'] ?? '',
        'webhook'      => $_REQUEST['webhook'] ?? '',
        'token'        => Settings_WPPConnect_Config::getConfig()['token'] ?? '' // 👈 mantiene il token esistente
    ];
    try {
        Settings_WPPConnect_Config::saveConfig($data);
        echo json_encode(['success'=>true,'message'=>'Configurazione salvata']);
    } catch (Exception $e) {
        echo json_encode(['success'=>false,'error'=>$e->getMessage()]);
    }
    break;


case 'load': // rilegge dal DB
    $cfg = Settings_WPPConnect_Config::getConfig();
    echo json_encode(['success'=>true,'data'=>$cfg]); // deve includere anche 'token'
    break;

case 'token':
    echo json_encode(WPPConnect_Api::generateToken());
    break;

case 'start':
    echo json_encode(WPPConnect_Api::start());
    break;

case 'status':
    $res = WPPConnect_Api::status();

    // aggiorna campo is_connected
    if (isset($res['success']) && $res['success'] && isset($res['data']['status'])) {
        $isConnected = false;
        $st = $res['data']['status'];
        if (is_bool($st)) {
            $isConnected = $st;
        } elseif (is_string($st)) {
            $isConnected = (strtoupper($st) === 'CONNECTED');
        }

        global $adb;
        $adb->pquery("UPDATE vte_wppconnect_config SET is_connected=? WHERE id=1", [$isConnected ? 1 : 0]);
    }

    echo json_encode($res);
    break;

case 'qrcode':
    echo json_encode(WPPConnect_Api::qrcode());
    break;

case 'logout':
    $res = WPPConnect_Api::logout();

    // al logout forza is_connected = 0
    if (isset($res['success']) && $res['success']) {
        global $adb;
        $adb->pquery("UPDATE vte_wppconnect_config SET is_connected=0 WHERE id=1");
    }

    echo json_encode($res);
    break;

default:
    echo json_encode(array(
        'success'=>false,
        'error'=>'Subaction non riconosciuta',
        'subaction'=>$subaction
    ));
    break;
}

exit;
